/*
<samplecode>
  <abstract>
  Sheet to present when a sync operation needs the player's attention.
  </abstract>
</samplecode>
*/

import SwiftUI

struct SyncSheet: View {
    @Environment(\.dismiss) var dismiss
    @Environment(GameSaveModel.self) var gsm: GameSaveModel
    
    @Binding var selectedVersion: SaveVersion?
    
    var body: some View {
        Group {
            if let syncState = gsm.syncState {
                switch syncState {
                case .syncing:
                    SyncProgress()
                case .conflict:
                    SavePicker(selectedVersion: $selectedVersion)
                        .environment(gsm)
                case .exception:
                    SyncException()
                        .environment(gsm)
                }
            } else {
                Label("Done", systemImage: "checkmark")
                    .font(.largeTitle)
            }
        }
        .interactiveDismissDisabled(gsm.syncState != nil)
    }
}

#Preview {
    struct ContainerView: View {
        @State var isPresented = true
        @State var selectedVersion: SaveVersion?
        
        var body: some View {
            VStack {
                Button("Merge") {
                    isPresented = true
                }
                .buttonStyle(.bordered)
                
                Text("\(String(describing: selectedVersion))")
                    .padding()
            }
            
            .sheet(isPresented: $isPresented) {
                SyncSheet(selectedVersion: $selectedVersion)
                    .environment(GameSaveModel.shared)
            }
        }
    }
    
    return ContainerView()
}
